/*
 * Convert the imaginary coordinates from the FFT to polar coordinates
 */

module cart_to_polar(
		input logic	    clk,

		// Communicate with ffter
		input logic	    go_in,

		// Read from post_fft_buf_real
		input logic [15:0]  real_buf_data,
		output logic [11:0] real_buf_addr = 0,

		// Read from post_fft_buf_imag
		input logic [15:0]  imag_buf_data,
		output logic [11:0] imag_buf_addr = 0,

		// Write to scaler_mag_buf_0
		output logic [15:0] mag_buf_0_data = 0,
		output logic [11:0] mag_buf_0_addr = 0,
		output logic        mag_buf_0_wren = 0,

		// Write to scaler_phase_buf_0
		output logic [15:0] phase_buf_0_data = 0,
		output logic [11:0] phase_buf_0_addr = 0,
		output logic        phase_buf_0_wren = 0,

		// Write to scaler_mag_buf_1
		output logic [15:0] mag_buf_1_data = 0,
		output logic [11:0] mag_buf_1_addr = 0,
		output logic        mag_buf_1_wren = 0,

		// Write to scaler_phase_buf_1
		output logic [15:0] phase_buf_1_data = 0,
		output logic [11:0] phase_buf_1_addr = 0,
		output logic        phase_buf_1_wren = 0,

		// Communicate with scaler
		output logic        cur_buf = 0,
		output logic	    go_out = 0
	);

logic [15:0] magnitude;
logic [15:0] phase;
logic [11:0] n_samples = 0;
logic aux, i_ce, done;

// Instance of the polar_converter
topolar polar_converter (
    .i_clk(clk),
    .i_reset(!go_in),
    .i_ce(i_ce),
    .i_xval(real_buf_data[15:0]),
    .i_yval(imag_buf_data[15:0]),
    .i_aux(aux),
    .o_mag(magnitude),
    .o_phase(phase),
    .o_aux(aux)
	.o_done(done)
);

always_ff @(posedge clk) begin
	if (!going) begin
    	if (go_in) begin
        	// Start of processing
			going <=1;
			go_out <=0;
        	i_ce <= 1;
			curr_buf <= !curr_buf;

		end
    end else begin
        // Perform address increment and data processing
		if (done) begin
		    real_buf_addr <= real_buf_addr + 1;
        	imag_buf_addr <= imag_buf_addr + 1;
			n_samples <= n_samples + 1;

			if (!curr_buf) begin

				mag_buf_0_data <= magnitude;
				mag_buf_0_addr <= real_buf_addr - 1;
				mag_buf_0_wren <= 1;
				phase_buf_0_data <= phase[15:0];
				phase_buf_0_addr <= real_buf_addr - 1;
				phase_buf_0_wren <= 1;
			end
			else begin
				mag_buf_1_data <= magnitude;
				mag_buf_1_addr <= real_buf_addr - 1;
				mag_buf_1_wren <= 1;
				phase_buf_1_data <= phase[15:0];
				phase_buf_1_addr <= real_buf_addr - 1;
				phase_buf_1_wren <= 1;
			end

			if (n_samples == 12'd4095) begin 
				going <= 0;
				go_out <= 1;
			end
		end
end

endmodule
